capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Stata Index"
set more off
log using Output/log/anTNSP25-firm-exens, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics 2025 TNSP Benchmarking
Author:  Michael Cunningham
File:     anTNSP25-firm-exens.do
Initial Date:   7-Jul-2022
Revised Date:   8-Jul-2025
--------------------------------------------------------------------------*/

scalar define rss1     = 0.09445
scalar define rss2     = 0.28685
scalar define rss3     = 0.0933
scalar define rss4     = 0.5254

local outputs energy ratchetmd customers circlength
local inputs ropex overline undercable transform
local costs opex auc_overline auc_undercable auc_transform

tempfile combodat

* append datasets

use Input/dta/tnspbench25-firm, clear
drop tnspyear state
append using Input/dta/tnspbench25-ind.dta
order tnsp year
sort tnsp year

save `combodat'


* Read dataset & create variables

forvalues z = 21/26 {
	
use `combodat', clear
keep if tnsp == `z'
sort year

describe, fullnames
summarize

* output and input quantities

local j = 1
foreach i of local outputs {
	gen q`j' = `i'
	local ++j
}

local j = 1
foreach i of local inputs {
	gen x`j' = `i'
	local ++j
}

* Input costs and cost shares

local j = 1
foreach i of local costs {
	gen c`j' = `i'
	local ++j
}
gen tc = c1 + c2 + c3 + c4

forvalues i = 1/4 {
	gen cs`i' = c`i' / tc
	gen w`i' = c`i' / x`i'
	gen lx`i' = log(x`i')
}

* Capital inputs only

gen kc = c2 + c3 + c4
forvalues i = 2/4 {
	gen ks`i' = c`i' / kc
}

* Output values and value shares


forvalues i = 1/4 {
	gen v`i' = rss`i'*revenue
}

forvalues i = 1/4 {
	gen vs`i' = rss`i'
	gen p`i' = v`i'/ q`i'
	gen lq`i' = log(q`i')
}

* Means & Lags

forvalues j = 1/4 {
	summarize lx`j', meanonly 
	scalar define lx`j'_m = r(mean)
	summarize cs`j', meanonly 
	scalar define cs`j'_m = r(mean)	
	gen lx`j'_l = lx`j'[_n-1]
	gen cs`j'_l = cs`j'[_n-1]	
}

forvalues j = 1/4 {
	summarize lq`j', meanonly 
	scalar define lq`j'_m = r(mean)
	summarize vs`j', meanonly 
	scalar define vs`j'_m = r(mean)	
	gen lq`j'_l = lq`j'[_n-1]
	gen vs`j'_l = vs`j'[_n-1]	
}

scalar list
describe

* Output Index

foreach k of numlist 1/4 {
	gen outdelta`k' = (vs`k' + vs`k'_m)*(lq`k' - lq`k'_m)/2 ///
			      - (vs`k'_l + vs`k'_m)*(lq`k'_l - lq`k'_m)/2
}
gen outdelta = outdelta1 + outdelta2 + outdelta3 + outdelta4
gen outx = 1
replace outx = outx[_n-1] * exp(outdelta) if _n > 1 

* Input Index

foreach k of numlist 1/4 {
	gen indelta`k' = - ((cs`k' + cs`k'_m)*(lx`k' - lx`k'_m)/2 ///
			      - (cs`k'_l + cs`k'_m)*(lx`k'_l - lx`k'_m)/2)
}
gen indelta = indelta1 + indelta2 + indelta3 + indelta4
gen inx = 1
replace inx = inx[_n-1] * exp(-indelta) if _n > 1 

* TFP Index

gen tfpdelta = outdelta + indelta
gen tfpx = 1
replace tfpx = tfpx[_n-1] * exp(tfpdelta) if _n > 1 


* Write results file

export excel tnsp year outx inx tfpx using Output/excel/tnsp25_tsmtfp_exens.xlsx, ///
	sheet("`z'", replace) firstrow(var)

}

log close
exit
